-- Create the location weighted version of the annual results by summing the results of the previous table,
--  Add the results to the measure impacts table.
SET search_path TO "MC_results_database";
DELETE FROM meas_impacts_wtd WHERE "BldgType" = 'Com';
INSERT INTO meas_impacts_wtd
SELECT
"EnergyImpactID",
'DEER2020'::VARCHAR as "Version",
'D20v0'::VARCHAR as "VersionSource",
date_trunc('second', now()) as "LastMod",
"PA",
'Com'::VARCHAR as "BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC",
"NormUnit",
(Sum("NumUnit") / Sum(wt_bldg))::numeric(15,5) AS "NumUnit",
(Sum("MeasArea") / Sum(wt_bldg))::numeric(15,0) AS "MeasArea",
"ScaleBasis",
(Sum("APreWBkWh") / Sum(wt_bldg))::numeric(15,5) as "APreWBkWh",
(Sum("APreWBkW") / Sum(wt_bldg))::numeric(15,5) as "APreWBkW",
(Sum("APreWBtherm") / Sum(wt_bldg))::numeric(15,5) as "APreWBtherm",
(Sum("AStdWBkWh") / Sum(wt_bldg))::numeric(15,5) as "AStdWBkWh",
(Sum("AStdWBkW") / Sum(wt_bldg))::numeric(15,5) as "AStdWBkW",
(Sum("AStdWBtherm") / Sum(wt_bldg))::numeric(15,5) as "AStdWBtherm"
from meas_impacts_tmp3
GROUP BY
"EnergyImpactID",
"PA",
"BldgVint",
"BldgLoc",
"BldgHVAC",
"NormUnit",
"ScaleBasis"
ORDER BY 
"EnergyImpactID",
"PA",
"BldgVint",
"BldgHVAC";